
function [outI1, outI2, A1, A2] = colourAugment(I1,I2,A1,A2, colourStdDev)
%COLOURAUGMENT Recolour both images independently by 
% shifting the RGB channels a random amount sampled from gaussian

% I1 and I2 are 3-channel images (RGB)
% A1 and A2 are the annotations (YOLO bounding boxes)
    outI1 = zeros(size(I1), 'uint8');
    outI2 = zeros(size(I2), 'uint8');
    for channel = 1:3
        outI1(:,:,channel) = imadd(I1(:,:,channel), normrnd(0, colourStdDev));
        outI2(:,:,channel) = imadd(I2(:,:,channel), normrnd(0, colourStdDev));
    end
    
    outI1 = applyMask(outI1, I1);
    outI2 = applyMask(outI2, I2);

end

